//--------------------------------------------------------------------------------------//
//                  : draw.h
//                : 1.0.0.0
//                 :   
//                : 19.08.2001
//--------------------------------------------------------------------------------------//
//    :         ,
//                  ,    
//               ,        .
//--------------------------------------------------------------------------------------//
//    /,        :
//              e-mail: info@sikorskyy.com.ua
//           :
//              www: sikorskyy.com.ua
//--------------------------------------------------------------------------------------//

#pragma once

//   
struct _shadowInf
{
  int nShadowDist;
  int nIntensity;
  int nLightPos;
  int nLightDist;
};

//  
struct _RGBMul
{
  double _nRed;
  double _nGreen;
  double _nBlue;
};

class CDraw
{
public:
  CDraw(void);
  ~CDraw(void);
  
  //,   -  
#define _POS_L                         1
#define _POS_LT                        2
#define _POS_T                         3
#define _POS_RT                        4
#define _POS_R                         5
#define _POS_RB                        6
#define _POS_B                         7
#define _POS_LB                        8

  //   _shadowInf
  _shadowInf mkShadowInf(const int nShadowDist = 1, const int nLightDist = 2,
                         const int nIntensity = 10, const int nLightPos = _POS_LT);

  //     
 	void drawLn(CDC *pDC, int x1, int y1, int x2, int y2, COLORREF clrLine);

  //,    
#define _VERTICAL								1
#define _HORIZONTAL							2
#define _LTDIAGONAL             3
#define _LBDIAGONAL             4
	
	//      
	void drawGradation(CDC *pDC, const CRect rect, const COLORREF clrFirst, const COLORREF clrLast,
                     const int nDir);

  //      
  void drawGradation(CDC *pDC, const CRect rect, const COLORREF clrLT, const COLORREF clrRT,
                     const COLORREF clrLB, const COLORREF clrRB);

  //       
  void drawGradation(CDC *pDC, const CPoint point, const COLORREF clrFirst, const COLORREF clrLast,
                     const int nRadius);

  void drawXXX(CDC *pDC, const CRect rect, const COLORREF clrFirstA, const COLORREF clrLastA,
               const COLORREF clrFirstB, const COLORREF clrLastB, const int nDir);

//,      
#define _CONVEX                  1
#define _CONCAVE                 2
#define _FLAT                    3

	// 3-     
	void draw3dRect(CDC *pDC, CRect rect, const COLORREF clrClr, const int nThickness,
                  const int nType = _CONVEX);

  // 3-     
  void draw3dRect(CDC *pDC, CRect rect, const COLORREF clrFirst, const COLORREF clrLast,
                  const int nDir, const int nThickness, const int nType = _CONVEX);

  // 3-     
  void draw3dRect(CDC *pDC, CRect rect, const COLORREF clrLT, const COLORREF clrRT,
                  const COLORREF clrLB, const COLORREF clrRB,
                  const int nThickness, const int nType = _CONVEX);

  //   100%
  void blackAndWhiteRect(CDC *pDC, const CRect rect);

  //   nPercents%
  void blackAndWhiteRect(CDC *pDC, const CRect rect, const int nPercents);

  //       100%
  void redOnlyRect(CDC *pDC, const CRect rect);

  //       nPercents%
  void redOnlyRect(CDC *pDC, const CRect rect, const int nPercents);

  //       100%
  void greenOnlyRect(CDC *pDC, const CRect rect);

  //       nPercents%
  void greenOnlyRect(CDC *pDC, const CRect rect, const int nPercents);

  //       100%
  void blueOnlyRect(CDC *pDC, const CRect rect);

  //       nPercents%
  void blueOnlyRect(CDC *pDC, const CRect rect, const int nPercents);

  //   nPercents%
  void lightenRect(CDC *pDC, const CRect rect, const int nPercents);

  //   nPercents%
  void darkenRect(CDC *pDC, const CRect rect, const int nPercents);

  //   nPercents%
	COLORREF lightenClr(const COLORREF clrClr, const int nPercents);

  //   nPercents%
	COLORREF darkenClr(const COLORREF clrClr, const int nPercents);

  // 
  COLORREF invertClr(const COLORREF clrClr);

  //    
  void drawText(CDC *pDC, CFont *pFont, const CPoint pPos, const CString strText, const COLORREF clrText,
                _shadowInf nShadow);

protected:
  //   *nAdd          nChange
  void _increaseMul(_RGBMul *nAdd, const COLORREF clrClr, const _RGBMul nChange);

  //   *nSbt          nChange
  void _decreaseMul(_RGBMul *nSbt, const COLORREF clrClr, const _RGBMul nChange);

//( bType  _mkChange)
#define _L                     0
#define _D                     1

  //          ()
  _RGBMul _mkChange(const BOOL bType, const COLORREF clrClr, const int nThickness);

  //          ()
  _RGBMul _mkChange(const COLORREF clrFirst, const COLORREF clrLast, const int nPixels);

//( bOperation  _mkClr)
#define _ADD                   0
#define _SBT                   1

  //         
  COLORREF _mkClr(const BOOL bOperation, const COLORREF clrClr, _RGBMul nDifference);

  //   
  CRect _mkLnRect(const CRect rect, const int nPosition);

//( nFillLns  _draw...Gradient)
#define _FLNS_ALL              1
#define _FLNS_EVERYSECOND      2
#define _FLNS_EVERYTHIRD       3

  //          
  int _getPxlNum(const CRect rect, const int nDir);

  //          
  void _drawVerticalGradient(CDC *pDC, const CRect rect, const COLORREF clrFirst, const _RGBMul nChange, const int nFillLns = _FLNS_ALL);
  
  //          
  void _drawHorizontalGradient(CDC *pDC, const CRect rect, const COLORREF clrFirst, const _RGBMul nChange, const int nFillLns = _FLNS_ALL);

  //  ( . . )         
  void _drawDiagonalGradient(CDC *pDC, const CRect rect, const COLORREF clrFirst, const _RGBMul nChange, const int nDir, const int nFillLns = _FLNS_ALL);

  //      
  void _drawConvex3dRect(CDC *pDC, CRect rect, const COLORREF clrLeftTop, const COLORREF clrRightTop,
                         const COLORREF clrLeftBottom, const COLORREF clrRightBottom,
                         const int nThickness);

  //      
  void _drawConcave3dRect(CDC *pDC, CRect rect, const COLORREF clrLeftTop, const COLORREF clrRightTop,
                          const COLORREF clrLeftBottom, const COLORREF clrRightBottom,
                          const int nThickness);

  //      
  void _drawFlat3dRect(CDC *pDC, CRect rect, const COLORREF clrLeftTop, const COLORREF clrRightTop,
                       const COLORREF clrLeftBottom, const COLORREF clrRightBottom);
};
