//--------------------------------------------------------------------------------------//
//                  : draw.cpp
//                : 1.0.0.0
//                 :   
//                : 19.08.2001
//--------------------------------------------------------------------------------------//
//    :         ,
//                  ,    
//               ,        .
//--------------------------------------------------------------------------------------//
//    /,        :
//              e-mail: info@sikorskyy.com.ua
//           :
//              www: sikorskyy.com.ua
//--------------------------------------------------------------------------------------//

#include "StdAfx.h"
#include "draw.h"

CDraw::CDraw(void)
{
}

CDraw::~CDraw(void)
{
}

//   _shadowInf
_shadowInf CDraw::mkShadowInf(const int nShadowDist, const int nLightDist,
                              const int nIntensity, const int nLightPos)
{
  _shadowInf nShadow;

  nShadow.nShadowDist = nShadowDist;
  nShadow.nLightDist = nLightDist;
  nShadow.nIntensity = nIntensity;
  nShadow.nLightPos = nLightPos;
  return nShadow;
}

//     
void CDraw::drawLn(CDC *pDC, int x1, int y1, int x2, int y2, COLORREF clrLine)
{
  if(x1 != x2 && y1 != y2)
  {
	  CPen pNewPen;
	  CPen *pOldPen;

	  pNewPen.CreatePen(PS_SOLID, 1, clrLine);
	  pOldPen = pDC->SelectObject(&pNewPen);
	  pDC->MoveTo(x1, y1);
	  pDC->LineTo(x2, y2);
    pDC->SelectObject(pOldPen);
	  pNewPen.DeleteObject();
  }

  else
  {
    if(x1 == x2)
      pDC->FillSolidRect(x1, y1, 1, y2 - y1, clrLine);

    if(y1 == y2)
      pDC->FillSolidRect(x1, y1, x2 - x1, 1, clrLine);
  }
}

//      
void CDraw::drawGradation(CDC *pDC, const CRect rect, const COLORREF clrFirst,
                                     const COLORREF clrLast, const int nDir)
{
  const _RGBMul nChange = _mkChange(clrFirst, clrLast, _getPxlNum(rect, nDir));

  if(nDir == _VERTICAL)
    _drawVerticalGradient(pDC, rect, clrFirst, nChange);

  if(nDir == _HORIZONTAL)
    _drawHorizontalGradient(pDC, rect, clrFirst, nChange);

  if(nDir == _LTDIAGONAL || nDir == _LBDIAGONAL)
    _drawDiagonalGradient(pDC, rect, clrFirst, nChange, nDir);
}

//      
void CDraw::drawGradation(CDC *pDC, const CRect rect, const COLORREF clrLT, const COLORREF clrRT,
                                     const COLORREF clrLB, const COLORREF clrRB)
{
  CRect rectLine;
  _RGBMul nLAdd = {0.0, 0.0, 0.0}, nRAdd = {0.0, 0.0, 0.0};
  const _RGBMul nLChange = _mkChange(clrLT, clrLB, _getPxlNum(rect, _VERTICAL));
  const _RGBMul nRChange = _mkChange(clrRT, clrRB, _getPxlNum(rect, _VERTICAL));

  for(int i = rect.top; i != rect.bottom; i++)
  {
    rectLine.SetRect(rect.left, i, rect.right, i + 1);
    drawGradation(pDC, rectLine, _mkClr(_ADD, clrLT, nLAdd), _mkClr(_ADD, clrRT, nRAdd), _HORIZONTAL);
    _increaseMul(&nLAdd, clrLT, nLChange);
    _increaseMul(&nRAdd, clrRT, nRChange);
  }
}

//       
void CDraw::drawGradation(CDC *pDC, const CPoint point, const COLORREF clrFirst,
                                     const COLORREF clrLast, const int nRadius)
{
  _RGBMul nAdd = {0.0, 0.0, 0.0};
  const _RGBMul nChange = _mkChange(clrFirst, clrLast, nRadius);
  const double nQuality = 25.0;

  for(int i = 0; i != nRadius; i++)
  {
    for(double d = 0.0; d <= 360.0; d += 1 / (nRadius / nQuality))
      pDC->SetPixel(int(point.x + i * sin(d / 57.2957)), int(point.y + i * cos(d / 57.2957)), _mkClr(_ADD, clrFirst, nAdd));
    
    _increaseMul(&nAdd, clrFirst, nChange);
  }
}

void CDraw::drawXXX(CDC *pDC, const CRect rect, const COLORREF clrFirstA, const COLORREF clrLastA,
                               const COLORREF clrFirstB, const COLORREF clrLastB, const int nDir)
{
  CRect rectFill = rect;

  const _RGBMul nChangeA = _mkChange(clrFirstA, clrLastA, _getPxlNum(rect, nDir));
  const _RGBMul nChangeB = _mkChange(clrLastB, clrFirstB, _getPxlNum(rect, nDir));

  if(nDir == _VERTICAL)
  {
    _drawVerticalGradient(pDC, rectFill, clrFirstA, nChangeA, _FLNS_EVERYSECOND);
    rectFill.top++;
    _drawVerticalGradient(pDC, rectFill, clrLastB, nChangeB, _FLNS_EVERYSECOND);
  }

  if(nDir == _HORIZONTAL)
  {
    _drawHorizontalGradient(pDC, rectFill, clrFirstA, nChangeA, _FLNS_EVERYSECOND);
    rectFill.left++;
    _drawHorizontalGradient(pDC, rectFill, clrFirstB, nChangeB, _FLNS_EVERYSECOND);
  }
}

// 3-     
void CDraw::draw3dRect(CDC *pDC, CRect rect, const COLORREF clrClr, const int nThickness,
                                  const int nType)
{
  draw3dRect(pDC, rect, clrClr, clrClr, clrClr, clrClr, nThickness, nType);
}

// 3-     
void CDraw::draw3dRect(CDC *pDC, CRect rect, const COLORREF clrFirst, const COLORREF clrLast,
                                  const int nDir, const int nThickness, const int nType)
{
  if(nDir == _VERTICAL)
    draw3dRect(pDC, rect, clrFirst, clrFirst, clrLast, clrLast, nThickness, nType);

  if(nDir == _HORIZONTAL)
    draw3dRect(pDC, rect, clrFirst, clrLast, clrFirst, clrLast, nThickness, nType);
}

// 3-     
void CDraw::draw3dRect(CDC *pDC, CRect rect, const COLORREF clrLT, const COLORREF clrRT,
                                  const COLORREF clrLB, const COLORREF clrRB,
                                  const int nThickness, const int nType)
{
  if(nType == _CONVEX)
    _drawConvex3dRect(pDC, rect, clrLT, clrRT, clrLB, clrRB, nThickness);

  if(nType == _CONCAVE)
    _drawConcave3dRect(pDC, rect, clrLT, clrRT, clrLB, clrRB, nThickness);

  if(nType == _FLAT)
    for(int i = 0; i != nThickness; i++)
    {
      _drawFlat3dRect(pDC, rect, clrLT, clrRT, clrLB, clrRB);
      rect.DeflateRect(1, 1);
    }
}

//   100%
void CDraw::blackAndWhiteRect(CDC *pDC, const CRect rect)
{
  COLORREF clrClr = 0;
  
  for(int x = rect.left; x != rect.right; x++)
    for(int y = rect.top; y != rect.bottom; y++)
    {
      clrClr = pDC->GetPixel(x, y);
      clrClr = RGB((GetRValue(clrClr) + GetGValue(clrClr) + GetBValue(clrClr)) / 3,
                     (GetRValue(clrClr) + GetGValue(clrClr) + GetBValue(clrClr)) / 3,
                     (GetRValue(clrClr) + GetGValue(clrClr) + GetBValue(clrClr)) / 3);            
      pDC->SetPixel(x, y, clrClr);
    }
}

//   nPercents%
void CDraw::blackAndWhiteRect(CDC *pDC, const CRect rect, const int nPercents)
{
  COLORREF clrClr = 0;
  BYTE nAverage = 0;
  double nRed = 0.0, nGreen = 0.0, nBlue = 0.0;

  for(int x = rect.left; x != rect.right; x++)
    for(int y = rect.top; y != rect.bottom; y++)
    {
      clrClr = pDC->GetPixel(x, y);
      nAverage = (GetRValue(clrClr) + GetGValue(clrClr) + GetBValue(clrClr)) / 3;
      nRed = (nAverage - GetRValue(clrClr)) / 100.0;
      nGreen = (nAverage - GetGValue(clrClr)) / 100.0;
      nBlue = (nAverage - GetBValue(clrClr)) / 100.0;
      clrClr = RGB(GetRValue(clrClr) + nRed * nPercents,
                     GetGValue(clrClr) + nGreen * nPercents,
                     GetBValue(clrClr) + nBlue * nPercents);            
      pDC->SetPixel(x, y, clrClr);
    }
}

//       100%
void CDraw::redOnlyRect(CDC *pDC, const CRect rect)
{
  for(int x = rect.left; x != rect.right; x++)
    for(int y = rect.top; y != rect.bottom; y++)
      if(pDC->PtVisible(x, y))
        pDC->SetPixel(x, y, RGB(GetRValue(pDC->GetPixel(x, y)), 0, 0));
}

//       nPercents%
void CDraw::redOnlyRect(CDC *pDC, const CRect rect, const int nPercents)
{
  COLORREF clrClr = 0;

  for(int x = rect.left; x != rect.right; x++)
    for(int y = rect.top; y != rect.bottom; y++)
      if(pDC->PtVisible(x, y))
      {
        clrClr = pDC->GetPixel(x, y);
        clrClr = RGB(GetRValue(clrClr),
                       GetGValue(clrClr) - (GetGValue(clrClr) / 100.0 * nPercents),
                       GetBValue(clrClr) - (GetBValue(clrClr) / 100.0 * nPercents));
        pDC->SetPixel(x, y, clrClr);
      }
}

//       100%
void CDraw::greenOnlyRect(CDC *pDC, const CRect rect)
{
  for(int x = rect.left; x != rect.right; x++)
    for(int y = rect.top; y != rect.bottom; y++)
      if(pDC->PtVisible(x, y))
        pDC->SetPixel(x, y, RGB(0, GetGValue(pDC->GetPixel(x, y)), 0));
}

//       nPercents%
void CDraw::greenOnlyRect(CDC *pDC, const CRect rect, const int nPercents)
{
  COLORREF clrClr = 0;

  for(int x = rect.left; x != rect.right; x++)
    for(int y = rect.top; y != rect.bottom; y++)
      if(pDC->PtVisible(x, y))
      {
        clrClr = pDC->GetPixel(x, y);
        clrClr = RGB(GetRValue(clrClr) - (GetRValue(clrClr) / 100.0 * nPercents),
                       GetGValue(clrClr),
                       GetBValue(clrClr) - (GetBValue(clrClr) / 100.0 * nPercents));
        pDC->SetPixel(x, y, clrClr);
      }
}

//       100%
void CDraw::blueOnlyRect(CDC *pDC, const CRect rect)
{
  for(int x = rect.left; x != rect.right; x++)
    for(int y = rect.top; y != rect.bottom; y++)
      if(pDC->PtVisible(x, y))
        pDC->SetPixel(x, y, RGB(0, 0, GetBValue(pDC->GetPixel(x, y))));
}

//       nPercents%
void CDraw::blueOnlyRect(CDC *pDC, const CRect rect, const int nPercents)
{
  COLORREF clrClr = 0;

  for(int x = rect.left; x != rect.right; x++)
    for(int y = rect.top; y != rect.bottom; y++)
      if(pDC->PtVisible(x, y))
      {
        clrClr = pDC->GetPixel(x, y);
        clrClr = RGB(GetRValue(clrClr) - (GetRValue(clrClr) / 100.0 * nPercents),
                       GetGValue(clrClr) - (GetGValue(clrClr) / 100.0 * nPercents),
                       GetBValue(clrClr));
        pDC->SetPixel(x, y, clrClr);
      }
}

//   nPercents%
void CDraw::lightenRect(CDC *pDC, const CRect rect, const int nPercents)
{
  for(int x = rect.left; x != rect.right; x++)
    for(int y = rect.top; y != rect.bottom; y++)
      if(pDC->PtVisible(x, y))
        pDC->SetPixel(x, y, lightenClr(pDC->GetPixel(x, y), nPercents));
}

//   nPercents%
void CDraw::darkenRect(CDC *pDC, const CRect rect, const int nPercents)
{
  for(int x = rect.left; x != rect.right; x++)
    for(int y = rect.top; y != rect.bottom; y++)
      if(pDC->PtVisible(x, y))
        pDC->SetPixel(x, y, darkenClr(pDC->GetPixel(x, y), nPercents));
}

//   nPercents%
COLORREF CDraw::lightenClr(const COLORREF clrClr, const int nPercents)
{
	double nRed = GetRValue(clrClr);
	double nGreen = GetGValue(clrClr);
	double nBlue = GetBValue(clrClr);

  nRed = nRed + ((255 - nRed) / 100 * nPercents);
  nGreen = nGreen + ((255 - nGreen) / 100 * nPercents);
  nBlue = nBlue + ((255 - nBlue) / 100 * nPercents);
	return RGB(nRed, nGreen, nBlue);
}

//   nPercents%
COLORREF CDraw::darkenClr(const COLORREF clrClr, const int nPercents)
{
	double nRed = GetRValue(clrClr);
	double nGreen = GetGValue(clrClr);
	double nBlue = GetBValue(clrClr);

  nRed = nRed - (nRed / 100 * nPercents);
  nGreen = nGreen - (nGreen / 100 * nPercents);
  nBlue = nBlue - (nBlue / 100 * nPercents);
	return RGB(nRed, nGreen, nBlue);
}

// 
COLORREF CDraw::invertClr(const COLORREF clrClr)
{
  return RGB(255 - GetRValue(clrClr), 255 - GetGValue(clrClr), 255 - GetBValue(clrClr));
}

//    
void CDraw::drawText(CDC *pDC, CFont *pFont, const CPoint pPos, const CString strText,
                                const COLORREF clrText, _shadowInf nShadow)
{
  int nDC = pDC->SaveDC();
  CFont *pOldFont = pDC->SelectObject(pFont);
  CSize sz = pDC->GetTextExtent(strText);
  CRect rectTextBk;
  
  if(strText.GetLength() >= 1)
  {
    pDC->GetClipBox(&rectTextBk);
    pDC->BeginPath();
    pDC->SetBkMode(TRANSPARENT);
    pDC->TextOut(pPos.x + nShadow.nShadowDist, pPos.y + nShadow.nShadowDist, strText);
    pDC->EndPath();
    pDC->SelectClipPath(RGN_AND);

    for(int i = 0; i != nShadow.nLightDist; i++)
    {
      darkenRect(pDC, rectTextBk, nShadow.nIntensity / (1 + i));

      if(nShadow.nLightPos == _POS_L)
        pDC->OffsetClipRgn(1, 0);

      if(nShadow.nLightPos == _POS_LT)
        pDC->OffsetClipRgn(1, 1);

      if(nShadow.nLightPos == _POS_T)
        pDC->OffsetClipRgn(0, 1);

      if(nShadow.nLightPos == _POS_RT)
        pDC->OffsetClipRgn(-1, 1);

      if(nShadow.nLightPos == _POS_R)
        pDC->OffsetClipRgn(-1, 0);

      if(nShadow.nLightPos == _POS_RB)
        pDC->OffsetClipRgn(-1, -1);

      if(nShadow.nLightPos == _POS_B)
        pDC->OffsetClipRgn(0, -1);

      if(nShadow.nLightPos == _POS_LB)
        pDC->OffsetClipRgn(1, -1);

    }

    pDC->SelectClipRgn(NULL);
    pDC->SetTextColor(clrText);
    pDC->TextOut(pPos.x, pPos.y, strText);
    pDC->RestoreDC(nDC);
  }
}

//   *nAdd          nChange
void CDraw::_increaseMul(_RGBMul *nAdd, const COLORREF clrClr, const _RGBMul nChange)
{
  nAdd->_nRed += ((GetRValue(clrClr) + nAdd->_nRed + nChange._nRed) <= 255.0) ? nChange._nRed : 0.0;
  nAdd->_nGreen += ((GetGValue(clrClr) + nAdd->_nGreen + nChange._nGreen) <= 255.0) ? nChange._nGreen : 0.0;
  nAdd->_nBlue += ((GetBValue(clrClr) + nAdd->_nBlue + nChange._nBlue) <= 255.0) ? nChange._nBlue : 0.0;
}

//   *nSbt          nChange
void CDraw::_decreaseMul(_RGBMul *nSbt, const COLORREF clrClr, const _RGBMul nChange)
{
  nSbt->_nRed += ((GetRValue(clrClr) - nSbt->_nRed - nChange._nRed) >= 0.0) ? nChange._nRed : 0.0;
  nSbt->_nGreen += ((GetGValue(clrClr) - nSbt->_nGreen - nChange._nGreen) >= 0.0) ? nChange._nGreen : 0.0;
  nSbt->_nBlue += ((GetBValue(clrClr) - nSbt->_nBlue - nChange._nBlue) >= 0.0) ? nChange._nBlue : 0.0;
}

//          ()
_RGBMul CDraw::_mkChange(const BOOL bType, const COLORREF clrClr, const int nThickness)
{
  _RGBMul nChange = {0.0, 0.0, 0.0};

  if(bType == _L)
  {
    nChange._nRed = (255 - GetRValue(clrClr)) / (float) nThickness;
    nChange._nGreen = (255 - GetGValue(clrClr)) / (float) nThickness;
    nChange._nBlue = (255 - GetBValue(clrClr)) / (float) nThickness;
  }

  else
  {
    nChange._nRed = (GetRValue(clrClr)) / (float) nThickness / 2.0;
    nChange._nGreen = (GetGValue(clrClr)) / (float) nThickness / 2.0;
    nChange._nBlue = (GetBValue(clrClr)) / (float) nThickness / 2.0;
  }

  return nChange;
}

//          ()
_RGBMul CDraw::_mkChange(const COLORREF clrFirst, const COLORREF clrLast, const int nPixels)
{
  _RGBMul nChange = {0.0, 0.0, 0.0};

  nChange._nRed = (GetRValue(clrLast) - GetRValue(clrFirst)) / (float) nPixels;
  nChange._nGreen = (GetGValue(clrLast) - GetGValue(clrFirst)) / (float) nPixels;
  nChange._nBlue = (GetBValue(clrLast) - GetBValue(clrFirst)) / (float) nPixels;
  return nChange;
}

//         
COLORREF CDraw::_mkClr(const BOOL bOperation, const COLORREF clrClr, _RGBMul nDifference)
{
  if(bOperation == _ADD)
    return RGB(GetRValue(clrClr) + nDifference._nRed,
               GetGValue(clrClr) + nDifference._nGreen,
               GetBValue(clrClr) + nDifference._nBlue);
  
  else
    return RGB(GetRValue(clrClr) - nDifference._nRed,
               GetGValue(clrClr) - nDifference._nGreen,
               GetBValue(clrClr) - nDifference._nBlue);
}

//   
CRect CDraw::_mkLnRect(const CRect rect, const int nPosition)
{
  CRect rectLine;

  if(nPosition == _POS_L)
    rectLine.SetRect(rect.left, rect.top, rect.left + 1, rect.bottom);

  if(nPosition == _POS_T)
    rectLine.SetRect(rect.left, rect.top, rect.right, rect.top + 1);

  if(nPosition == _POS_R)
    rectLine.SetRect(rect.right - 1, rect.top, rect.right, rect.bottom);

  if(nPosition == _POS_B)
    rectLine.SetRect(rect.left, rect.bottom - 1, rect.right, rect.bottom);

  return rectLine;
}

//          
int CDraw::_getPxlNum(const CRect rect, const int nDir)
{
  if(nDir == _VERTICAL)
    return rect.Height();

  if(nDir == _HORIZONTAL)
    return rect.Width();

  if(nDir == _LTDIAGONAL || nDir == _LBDIAGONAL)
    return int((rect.Height() + rect.Width()));

  return 0;
}

//          
void CDraw::_drawVerticalGradient(CDC *pDC, const CRect rect, const COLORREF clrFirst, const _RGBMul nChange, const int nFillLns)
{
  _RGBMul nAdd = {0.0, 0.0, 0.0};

  for(int i = rect.top; i < rect.bottom; i += nFillLns)
  {
    drawLn(pDC, rect.left, i, rect.right, i, _mkClr(_ADD, clrFirst, nAdd));
    _increaseMul(&nAdd, clrFirst, nChange);
  }
}

//          
void CDraw::_drawHorizontalGradient(CDC *pDC, const CRect rect, const COLORREF clrFirst, const _RGBMul nChange, const int nFillLns)
{
  _RGBMul nAdd = {0.0, 0.0, 0.0};

  for(int i = rect.left; i < rect.right; i += nFillLns)
  {
    drawLn(pDC, i, rect.top, i, rect.bottom, _mkClr(_ADD, clrFirst, nAdd));
    _increaseMul(&nAdd, clrFirst, nChange);
  }
}

//  ( . . )         
void CDraw::_drawDiagonalGradient(CDC *pDC, const CRect rect, const COLORREF clrFirst, const _RGBMul nChange, const int nDir, const int nFillLns)
{
  _RGBMul nAdd = {0.0, 0.0, 0.0};
  CRect rectFill = rect;
  int nDC = pDC->SaveDC();

  if(nDir == _LTDIAGONAL)
    rectFill.InflateRect(0, 1, 1, 1);

  if(nDir == _LBDIAGONAL)
    rectFill.InflateRect(0, 0, 1, 1);

  pDC->BeginPath();
  pDC->SetBkMode(TRANSPARENT);
  pDC->Rectangle(rectFill);
  pDC->EndPath();
  pDC->SelectClipPath(RGN_AND);

  for(int i = 0; i < rectFill.Width() + rectFill.Height() + 1; i += nFillLns)
  {
    if(nDir == _LTDIAGONAL)
      drawLn(pDC, rectFill.left, rectFill.top + i, rectFill.left + i, rectFill.top, _mkClr(_ADD, clrFirst, nAdd));
    
    if(nDir == _LBDIAGONAL)
      drawLn(pDC, rectFill.left, rectFill.bottom - i, rectFill.left + i, rectFill.bottom, _mkClr(_ADD, clrFirst, nAdd));
    
    _increaseMul(&nAdd, clrFirst, nChange);
  }

  pDC->SelectClipPath(NULL);
  pDC->RestoreDC(nDC);
}

//      
void CDraw::_drawConvex3dRect(CDC *pDC, CRect rect, const COLORREF clrLT, const COLORREF clrRT,
                                         const COLORREF clrLB, const COLORREF clrRB, const int nThickness)
{
   _RGBMul nLTLAdd = {0.0, 0.0, 0.0}, nRTLAdd = {0.0, 0.0, 0.0}, nLBLAdd = {0.0, 0.0, 0.0},
           nRTDSbt = {0.0, 0.0, 0.0}, nLBDSbt = {0.0, 0.0, 0.0}, nRBDSbt = {0.0, 0.0, 0.0};
  const _RGBMul nLTLChange = _mkChange(_L, clrLT, nThickness);
  const _RGBMul nRTLChange = _mkChange(_L, clrRT, nThickness);
  const _RGBMul nLBLChange = _mkChange(_L, clrLB, nThickness);
  const _RGBMul nRTDChange = _mkChange(_D, clrRT, nThickness);
  const _RGBMul nLBDChange = _mkChange(_D, clrLB, nThickness);
  const _RGBMul nRBDChange = _mkChange(_D, clrRB, nThickness);

  if(nThickness > 1)
  {
    for(int a = 0; a != nThickness; a++)
    {
      drawGradation(pDC, _mkLnRect(rect, _POS_T), _mkClr(_ADD, clrLT, nLTLAdd), _mkClr(_ADD, clrRT, nRTLAdd), _HORIZONTAL);
      drawGradation(pDC, _mkLnRect(rect, _POS_L), _mkClr(_ADD, clrLT, nLTLAdd), _mkClr(_ADD, clrLB, nLBLAdd), _VERTICAL);
      _increaseMul(&nLTLAdd, clrLT, nLTLChange);
      _increaseMul(&nRTLAdd, clrRT, nRTLChange);
      _increaseMul(&nLBLAdd, clrLB, nLBLChange);
      rect.DeflateRect(1, 1);
    }

    for(int b = 0; b != nThickness; b++)
    {
      rect.InflateRect(1, 1);
      _decreaseMul(&nRTDSbt, clrRT, nRTDChange);
      _decreaseMul(&nLBDSbt, clrLB, nLBDChange);
      _decreaseMul(&nRBDSbt, clrRB, nRBDChange);
      drawGradation(pDC, _mkLnRect(rect, _POS_B), _mkClr(_SBT, clrLB, nLBDSbt), _mkClr(_SBT, clrRB, nRBDSbt), _HORIZONTAL);
      drawGradation(pDC, _mkLnRect(rect, _POS_R), _mkClr(_SBT, clrRT, nRTDSbt), _mkClr(_SBT, clrRB, nRBDSbt), _VERTICAL);
    }
  }

  else
  {
    drawGradation(pDC, _mkLnRect(rect, _POS_T), lightenClr(clrLT, 50), lightenClr(clrRT, 50), _HORIZONTAL);
    drawGradation(pDC, _mkLnRect(rect, _POS_L), lightenClr(clrLT, 50), lightenClr(clrLB, 50), _VERTICAL);
    drawGradation(pDC, _mkLnRect(rect, _POS_B), darkenClr(clrLB, 40), darkenClr(clrRB, 40), _HORIZONTAL);
    drawGradation(pDC, _mkLnRect(rect, _POS_R), darkenClr(clrRT, 40), darkenClr(clrRB, 40), _VERTICAL);
  }
}

//      
void CDraw::_drawConcave3dRect(CDC *pDC, CRect rect, const COLORREF clrLT, const COLORREF clrRT,
                                          const COLORREF clrLB, const COLORREF clrRB, const int nThickness)
{
   _RGBMul nLTDSbt = {0.0, 0.0, 0.0}, nRTDSbt = {0.0, 0.0, 0.0}, nLBDSbt = {0.0, 0.0, 0.0},
           nRTLAdd = {0.0, 0.0, 0.0}, nLBLAdd = {0.0, 0.0, 0.0}, nRBLAdd = {0.0, 0.0, 0.0};
  const _RGBMul nLTDChange = _mkChange(_D, clrLT, nThickness);
  const _RGBMul nRTDChange = _mkChange(_D, clrRT, nThickness);
  const _RGBMul nLBDChange = _mkChange(_D, clrLB, nThickness);
  const _RGBMul nRTLChange = _mkChange(_L, clrRT, nThickness);
  const _RGBMul nLBLChange = _mkChange(_L, clrLB, nThickness);
  const _RGBMul nRBLChange = _mkChange(_L, clrRB, nThickness);

  if(nThickness > 1)
  {
    for(int i = 0; i != nThickness; i++)
    {
      drawGradation(pDC, _mkLnRect(rect, _POS_B), _mkClr(_ADD, clrLB, nLBLAdd), _mkClr(_ADD, clrRB, nRBLAdd), _HORIZONTAL);
      drawGradation(pDC, _mkLnRect(rect, _POS_R), _mkClr(_ADD, clrRT, nRTLAdd), _mkClr(_ADD, clrRB, nRBLAdd), _VERTICAL);
      _increaseMul(&nRTLAdd, clrRT, nRTLChange);
      _increaseMul(&nLBLAdd, clrLB, nLBLChange);
      _increaseMul(&nRBLAdd, clrRB, nRBLChange);
      _decreaseMul(&nLTDSbt, clrLT, nLTDChange);
      _decreaseMul(&nRTDSbt, clrRT, nRTDChange);
      _decreaseMul(&nLBDSbt, clrLB, nLBDChange);
      drawGradation(pDC, _mkLnRect(rect, _POS_T), _mkClr(_SBT, clrLT, nLTDSbt), _mkClr(_SBT, clrRT, nRTDSbt), _HORIZONTAL);
      drawGradation(pDC, _mkLnRect(rect, _POS_L), _mkClr(_SBT, clrLT, nLTDSbt), _mkClr(_SBT, clrLB, nLBDSbt), _VERTICAL);
      rect.DeflateRect(1, 1);
    }
  }

  else
  {
    drawGradation(pDC, _mkLnRect(rect, _POS_B), lightenClr(clrLB, 50), lightenClr(clrRB, 50), _HORIZONTAL);
    drawGradation(pDC, _mkLnRect(rect, _POS_R), lightenClr(clrRT, 50), lightenClr(clrRB, 50), _VERTICAL);
    drawGradation(pDC, _mkLnRect(rect, _POS_T), darkenClr(clrLT, 40), darkenClr(clrRT, 40), _HORIZONTAL);
    drawGradation(pDC, _mkLnRect(rect, _POS_L), darkenClr(clrLT, 40), darkenClr(clrLB, 40), _VERTICAL);
  }
}

//      
void CDraw::_drawFlat3dRect(CDC *pDC, CRect rect, const COLORREF clrLT, const COLORREF clrRT,
                                       const COLORREF clrLB, const COLORREF clrRB)
{
  drawGradation(pDC, _mkLnRect(rect, _POS_T), clrLT, clrRT, _HORIZONTAL);
  drawGradation(pDC, _mkLnRect(rect, _POS_B), clrLB, clrRB, _HORIZONTAL);
  drawGradation(pDC, _mkLnRect(rect, _POS_L), clrLT, clrLB, _VERTICAL);
  drawGradation(pDC, _mkLnRect(rect, _POS_R), clrRT, clrRB, _VERTICAL);
}